-- Follow-up tablosunu otomatik sistem için güncelle
ALTER TABLE `followups` 
ADD COLUMN `status` ENUM('pending', 'completed', 'overdue', 'cancelled') NOT NULL DEFAULT 'pending' AFTER `result`,
ADD COLUMN `priority` ENUM('low', 'normal', 'high', 'urgent') NOT NULL DEFAULT 'normal' AFTER `status`,
ADD COLUMN `auto_created` BOOLEAN DEFAULT FALSE AFTER `priority`,
ADD COLUMN `created_by` INT(11) NOT NULL AFTER `auto_created`,
ADD COLUMN `updated_by` INT(11) NULL AFTER `created_by`,
ADD COLUMN `updated_at` TIMESTAMP NULL ON UPDATE CURRENT_TIMESTAMP AFTER `updated_by`,
ADD INDEX `status` (`status`),
ADD INDEX `priority` (`priority`),
ADD INDEX `auto_created` (`auto_created`),
ADD CONSTRAINT `followups_created_by_fk` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE,
ADD CONSTRAINT `followups_updated_by_fk` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL;

-- Result alanını nullable yap (pending durumda henüz result yok)
ALTER TABLE `followups` 
MODIFY COLUMN `result` ENUM('answered','no_answer','busy','wrong_number','recovered','rejected','not_interested','callback_requested') NULL;

-- Follow-up bildirim tablosu oluştur
CREATE TABLE `followup_notifications` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `followup_id` int(11) NOT NULL,
  `notification_type` enum('due','overdue','urgent') NOT NULL,
  `sent_at` timestamp NULL DEFAULT NULL,
  `acknowledged_by` int(11) DEFAULT NULL,
  `acknowledged_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `followup_id` (`followup_id`),
  KEY `notification_type` (`notification_type`),
  KEY `sent_at` (`sent_at`),
  CONSTRAINT `followup_notifications_followup_fk` FOREIGN KEY (`followup_id`) REFERENCES `followups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `followup_notifications_user_fk` FOREIGN KEY (`acknowledged_by`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Follow-up geçmişi tablosu (detaylı takip için)
CREATE TABLE `followup_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `followup_id` int(11) NOT NULL,
  `action` enum('created','attempted','completed','rescheduled','cancelled') NOT NULL,
  `old_status` varchar(50) DEFAULT NULL,
  `new_status` varchar(50) DEFAULT NULL,
  `notes` text,
  `performed_by` int(11) NOT NULL,
  `performed_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `followup_id` (`followup_id`),
  KEY `action` (`action`),
  KEY `performed_by` (`performed_by`),
  KEY `performed_at` (`performed_at`),
  CONSTRAINT `followup_history_followup_fk` FOREIGN KEY (`followup_id`) REFERENCES `followups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `followup_history_user_fk` FOREIGN KEY (`performed_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Sistem ayarlarına follow-up konfigürasyonlarını ekle
INSERT INTO `settings` (`setting_key`, `setting_value`, `description`) VALUES
('auto_followup_hours', '48', 'Otomatik follow-up kaç saat sonra oluşturulsun'),
('overdue_warning_hours', '24', 'Follow-up gecikme uyarısı kaç saat sonra verilsin'),
('max_followup_attempts', '3', 'Maksimum follow-up deneme sayısı'),
('followup_reminder_enabled', '1', 'Follow-up hatırlatmaları aktif mi'),
('urgent_followup_hours', '72', 'Kaç saat sonra follow-up acil olarak işaretlensin')
ON DUPLICATE KEY UPDATE 
setting_value = VALUES(setting_value);