            </main>
    </div>
    
    <!-- Footer for logged in users -->
    <?php if (Auth::isLoggedIn()): ?>
    <footer class="footer">
        <div class="container-fluid px-4">
            <div class="d-flex justify-content-between align-items-center">
                <small class="text-muted">
                    © <?php echo date('Y'); ?> Alpi Diş Hastaneleri CRM v<?php echo APP_VERSION; ?>
                </small>
                <small class="text-muted">
                    Son güncelleme: <?php echo formatDateTime($_SESSION['last_activity'] ?? time()); ?>
                </small>
            </div>
        </div>
    </footer>
    <?php else: ?>
    <!-- Footer for public pages -->
    <footer class="footer-public">
        <div class="container">
            <p class="mb-0">© <?php echo date('Y'); ?> Alpi Diş Hastaneleri - Tüm hakları saklıdır.</p>
        </div>
    </footer>
    <?php endif; ?>

    <!-- Bootstrap JS Bundle -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- Custom JavaScript -->
    <script src="/public/assets/js/app.js"></script>
    
    <!-- Page specific scripts -->
    <?php if (isset($page_scripts)): ?>
        <?php foreach ($page_scripts as $script): ?>
            <script src="<?php echo $script; ?>"></script>
        <?php endforeach; ?>
    <?php endif; ?>
    
    <!-- Inline scripts -->
    <?php if (isset($inline_scripts)): ?>
        <script>
            <?php echo $inline_scripts; ?>
        </script>
    <?php endif; ?>
    
    <!-- Sidebar Toggle Script -->
    <?php if (Auth::isLoggedIn()): ?>
    <script>
        // Sidebar toggle for mobile
        document.addEventListener('DOMContentLoaded', function() {
            const sidebarToggle = document.getElementById('sidebarToggle');
            const sidebar = document.getElementById('sidebar');
            
            if (sidebarToggle && sidebar) {
                sidebarToggle.addEventListener('click', function() {
                    sidebar.classList.toggle('show');
                });
                
                // Close sidebar when clicking outside on mobile
                document.addEventListener('click', function(e) {
                    if (window.innerWidth < 768) {
                        if (!sidebar.contains(e.target) && !sidebarToggle.contains(e.target)) {
                            sidebar.classList.remove('show');
                        }
                    }
                });
            }
        });
        
        // Session timeout warning (5 minutes before expiry)
        setTimeout(function() {
            if (confirm('Oturumunuz yakında sona erecek. Devam etmek istiyor musunuz?')) {
                // Refresh page to extend session
                window.location.reload();
            } else {
                window.location.href = '/modules/users/logout.php';
            }
        }, <?php echo (AUTH::SESSION_TIMEOUT - 300) * 1000; ?>);
    </script>
    <?php endif; ?>
    
</body>
</html>