# Alpi Diş Hastaneleri CRM Sistemi

## Kurulum Talimatları

### 1. Sistem Gereksinimleri
- PHP 8.0 veya üzeri
- MySQL 5.7 veya üzeri
- Web sunucusu (Apache/Nginx)
- cPanel erişimi

### 2. Dosyaların Yüklenmesi
1. Tüm dosyaları cPanel File Manager ile public_html içine yükleyin
2. Dosya izinlerini kontrol edin:
   - Klasörler: 755
   - PHP dosyaları: 644
   - uploads klasörü: 777

### 3. Veritabanı Kurulumu
1. cPanel'de MySQL Databases bölümüne gidin
2. Veritabanı bilgileri:
   - **Veritabanı:** alpidisc_Balik
   - **Kullanıcı:** alpidisc_Balik1
   - **Şifre:** 52Pdcx-B(KfQ!gs9

3. phpMyAdmin'den `database_schema.sql` dosyasını import edin

### 4. Konfigürasyon
Veritabanı ayarları `config/database.php` dosyasında tanımlıdır:
```php
private $host = 'localhost';
private $db_name = 'alpidisc_Balik';
private $username = 'alpidisc_Balik1';
private $password = '52Pdcx-B(KfQ!gs9';
```

### 5. İlk Giriş
- **URL:** https://kb.alpidis.com
- **Kullanıcı Adı:** admin
- **Şifre:** admin123

## Özellikler

### 👥 Kullanıcı Rolleri
- **Patron (Owner):** Tüm sisteme erişim
- **Yönetici (Admin):** Şube bazlı yönetim
- **Satış (Sales):** Hasta ekleme/düzenleme
- **Çağrı Merkezi (Call Center):** Follow-up yönetimi

### 🏥 Şubeler
- Kaynarca
- Kartal
- Pendik
- Tuzla

### 📋 Ana Modüller

#### 1. Hasta Yönetimi
- **Hasta Ekleme:** Detaylı form ile hasta kaydı
- **Hasta Listesi:** Arama, filtreleme ve sayfalama
- **Hasta Durumları:** Bekleyen, Geri Kazanılan, Kaybedilen

#### 2. Follow-Up Sistemi
- **Otomatik Takip:** 3 gün sonra otomatik follow-up
- **Arama Yönetimi:** Arama sonuçları ve notlar
- **Maksimum Arama:** Hasta başına 3 arama limiti

#### 3. Raporlama
- **Dashboard İstatistikleri:** Anlık veriler
- **Performans Analizi:** Şube ve danışman bazlı
- **Excel Export:** Veri dışa aktarım

#### 4. Güvenlik
- **RBAC:** Role-based erişim kontrolü
- **CSRF Koruması:** Form güvenliği
- **Session Güvenliği:** IP kontrolü ve timeout
- **Password Hashing:** ARGON2ID algoritması

### 🎨 Tasarım Özellikleri
- **Responsive:** Mobile-first Bootstrap 5
- **Modern UI:** Clean ve minimalist tasarım
- **Dark/Light Theme:** Kullanıcı tercihi
- **İkonlar:** FontAwesome 6
- **Typography:** Inter Google Font

## Teknik Detaylar

### Veritabanı Tabloları
- `users` - Kullanıcı bilgileri
- `patients` - Hasta kayıtları
- `followups` - Arama geçmişi
- `branches` - Şube bilgileri
- `consultants` - Hasta danışmanları
- `reasons` - Anlaşmama nedenleri
- `activity_log` - İşlem geçmişi

### Güvenlik Özellikleri
- Password hashing (ARGON2ID)
- CSRF token koruması
- SQL Injection koruması
- XSS koruması
- Session hijacking koruması
- IP bazlı giriş kontrolü
- Başarısız giriş limiti

### Performans Optimizasyonları
- Database indexleri
- Sayfalama (pagination)
- Lazy loading
- CSS/JS minification
- Image optimization

## Bakım ve Güncelleme

### Log Dosyaları
- `logs/error.log` - PHP hataları
- `activity_log` tablosu - Kullanıcı işlemleri

### Yedekleme
- Veritabanı yedeği: phpMyAdmin export
- Dosya yedeği: cPanel backup

### Güvenlik Güncellemeleri
- PHP versiyonu güncel tutun
- SSL sertifikası aktif
- Güçlü şifreler kullanın
- Düzenli yedek alın

## Destek ve İletişim

Bu sistem Alpi Diş Hastaneleri için özel olarak geliştirilmiştir.

### Sistem Özellikleri
- ✅ Hasta kayıt ve takip sistemi
- ✅ Otomatik follow-up uyarıları
- ✅ Role-based erişim kontrolü
- ✅ Performans raporları
- ✅ Activity log sistemi
- ✅ Responsive tasarım
- ✅ Güvenli authentication
- ✅ CSRF koruması
- ✅ Excel export
- ✅ Mobil uyumlu

### Versiyon
- **Versiyon:** 1.0.0
- **Geliştirme Tarihi:** Ekim 2024
- **Son Güncelleme:** Ekim 2024

---

**© 2024 Alpi Diş Hastaneleri CRM - Tüm hakları saklıdır.**